<?php
class QueryRow implements Iterator {
	public $queryResult;
	public $db;
	private $row;
	private $itter;
	
	public function rewind() {
		return $this->itter->rewind();
	}

	public function current() {
		return $this->itter->current();
	}

	public function key() {
		return $this->itter->key();
	}

	public function next() {
		return $this->itter->next();
	}

	public function valid() {
		return $this->itter->valid();
	}
	
	public function createXML() {
		foreach($this as $k => $col) {
			echo "\t\t\t<$k>".xmlEncode($col)."</$k>\n";
		}
	}
	
	public function readyForInsert() {
		$arr=array();
		foreach($this as $k => $col) {
			$arr[]="\"".$this->db->escape_string($col)."\"";
		}
		
		return "(" . implode(", ",$arr) . ")\n";
	}
	
	public function createIdentityXML($tablename) {
		createTRXMLHeader();
		echo "<$tablename>";
?>
		<error><?php echo ($this->queryResult->error==0?"no":"yes"); ?></error>
		<errortext><?php echo xmlEncode($this->queryResult->errorText); ?></errortext>
		<errorno><?php echo $this->queryResult->error; ?></errorno>
<?php
		$this->createXML();
		echo "</$tablename>";
	}
	
	public function createTR() {
		foreach($this as $k => $col) {
			echo "\t\t<td>$col</td>\n";
		}
	}
		
	function __construct($row) {
		$this->row=$row;
		$obj=new ArrayObject($row);
		$this->itter=$obj->getIterator();
	}
	
	function delete() {
		if(isset($queryResult->fields["id"])) {
			if(!is_numeric($this->id))
				return false;
			return $db->execute(<<<QUERY
DELETE
FROM
	$queryResult->fields[id]->orgtable
WHERE
	id=$this->id
QUERY
			);
		} else {
			return false;
		}
	}
	
	function __get($name) {
		if(array_key_exists($name,$this->row)) {
			return $this->row[$name];
		} else {
			DebugLog::debugMessage("Undefined field name: $name",DebugLog::Warning);
		}
	}
	
	function __set($name,$value) {
		if(array_key_exists($name,$this->row)) {
			$this->row[$name]=$value;
		} else {
			DebugLog::debugMessage("Undefined field name: $name",DebugLog::Warning);
		}
	}
	
	function get($name) {
		if(!isset($name)) {
			array_dump( debug_backtrace());
		}
		if(array_key_exists($name,$this->row)) {
			return $this->row[$name];
		} else {
			DebugLog::debugMessage("Undefined field name: $name",DebugLog::Warning);
		}
	}
	
	function getAssocArray() {
		return $this->row;
	}
	
	function getArray() {
		return array_values($this->row);
	}
	
	function __isset($name) {
		return isset($this->row[$name]);
	}
}

class QueryResult implements Iterator {
	private $result;
	public $totalRows;
	public $count=0;
	public $error;
	public $errorText;
	public $db;
	public $table;
	public $totalPages;
	public $recordsPerPage;
	public $currentPage;
	public $firstRecord;
	public $lastRecord;
	public $fields=array();
	
	private $current=NULL;	
	private $currentRow=0;
	private $valid=false;
	
	function __construct($result,$error,$errorText,$totalRows,$recordsPerPage,$page) {
		$this->result=$result;
		$this->error=$error;
		$this->errorText=$errorText;
		$this->totalRows=$totalRows;
		$this->recordsPerPage=$recordsPerPage;
		if($this->recordsPerPage)
			$this->totalPages=ceil($totalRows/$recordsPerPage);
		if(!$page)
			$this->currentPage=1;
		elseif($page>$this->totalPages)
			$this->currentPage=$this->totalPages;
		else
			$this->currentPage=$page;
			
		$this->firstRecord=($this->currentPage-1)*$recordsPerPage+1;
		$this->lastRecord=($this->currentPage)*$recordsPerPage;
		
		if($this->firstRecord>$totalRows)
			$this->firstRecord=$totalRows;
		if($this->lastRecord>$totalRows)
			$this->lastRecord=$totalRows;
			
		if($this->lastRecord==0 && $totalRows>0)
			$this->lastRecord=$totalRows;
		
		if(!$error) {
			$this->count=$result->num_rows;
			
			while($f=$result->fetch_field())
				$this->fields[$f->name]=$f;
		}
	}
	
	public function rewind() {
		if($this->error==0) {
			$this->result->data_seek(0);
			$this->currentRow=0;
			$this->current=NULL;
		}
		
		$this->valid=false;
	}

	public function current() {
				//echo "-".$this->currentRow.", ";

		if($this->error)
			return NULL;
			
		if($this->current==NULL)
			return $this->next();
		else
			return $this->current;
	}

	public function key() {
			return $this->currentRow;
	}

	public function next() {
		if($this->error)
			return NULL;
			
		//echo ":".$this->currentRow.", ";
		
		$r=$this->result->fetch_assoc();
		if($r) {
			$var=new QueryRow($r);
			//print_r($var);
			$var->queryResult=$this;
			$var->db=$this->db;
			$this->current=$var;
			$this->currentRow++;
			$this->valid=true;
			
			return $var;
		} else {
			$this->valid=false;
		}
	}

	public function valid() {
			//echo $this->currentRow.", ";
			if($this->error)
				return false;
			elseif($this->valid===true)
				return true;
			else
				return $this->currentRow<$this->count;
	}
	
	public function createBarChart($title, $labelField, $valueField, $colorField="", $colorArray=array(), $zerobase=true) {
		include getLibPath() . "/ofc/open-flash-chart.php";
		$fullvals=array(1, 5, 10, 20, 50, 100, 250, 1000, 10000);

		$data = array();
		$axis = array();
		$colors=array();
		
		// add data values
		$mx=-0x7fffffff;
		$mn=0x7fffffff;
		foreach( $this as $row ) {
			if((float)$row->get($valueField)>$mx)
				$mx=(float)$row->get($valueField);
			if((float)$row->get($valueField)<$mn)
				$mn=(float)$row->get($valueField);
			
			if(isset($colorArray[$row->get($colorField)]))
				$colors=$colorArray[$row->get($colorField)] ;
			else
				$colors="#808080";
				
			$tmp=new bar_value((float)$row->get($valueField));
			$tmp->set_colour( $colors );
			$data[] = $tmp;
		  	$axis[] = $row->get($labelField);

		}
		
		if($zerobase && $mn>0)
			$mn=0;
		
		if($labelField=="0") {
			$axis=array();
			$i=0;
			foreach( $this as $row )
				$axis[]="".$i++;
		} elseif($labelField=="1") {
			$axis=array();
			$i=1;
			foreach( $this as $row )
				$axis[]="".$i++;
		} elseif($labelField=="") {
			$axis=array();
			foreach( $this as $row )
				$axis[]="";
		}
		
		$title = new title( $title );
		
		$bar = new bar_glass();
		$bar->set_values( $data );
		
		$x_axis = new x_axis();
		$x_axis->colour = '#909090';
		$axis=iso2utf($axis);
		$x_axis->set_labels_from_array( $axis );
		
		$steps=($mx-$mn)/10;
		foreach($fullvals as $v)
			if(abs($steps-$v)<$v/2) {
				$steps=$v;
				break;
			}
				
		
		$y= new y_axis();
		$y->set_range($mn, $mx, $steps);
		
		$bar = new bar_glass();
		$bar->set_values( $data );
		
		$chart = new open_flash_chart();
		$chart->set_title( $title );
		$chart->set_x_axis( $x_axis );
		$chart->set_y_axis( $y );
		$chart->add_element( $bar );
		$chart->set_bg_colour("#ffffff");

		echo $chart->toString();
	}
	
	public function createPieChart($title, $labelField, $valueField, $colorField="", $colorArray=array()) {
		include getLibPath() . "/ofc/open-flash-chart.php";

		$data = array();
		$axis = array();
		
		$colors=array();
		foreach( $this as $k=>$row ) {
			$tmp=new pie_value((float)$row->get($valueField),iso2utf($row->get($labelField)));
			
			if(isset($colorArray[$row->get($colorField)]))
				$colors[]=$colorArray[$row->get($colorField)] ;
			else
				$colors[]="#808080";
				
			$data[] = $tmp;
		}
		
		$title = new title( $title );
		
		$pie = new pie();
		$pie->start_angle(35)
			->add_animation( new pie_fade() )
			->add_animation( new pie_bounce(4) )
			//->label_colour('#000000') // <-- uncomment to see all labels set to blue
			->tooltip( '#val# of #total#<br>#percent# of 100%' )
			->colours($colors)
		    ->gradient_fill()
			;
		
		$pie->set_values( $data );		
		
		$chart = new open_flash_chart();
		$chart->set_title( $title );
		$chart->set_bg_colour("#ffffff");
		$chart->add_element( $pie );

		echo $chart->toString();
	}
	
	public function createXMLInfo() {
?>
		<totalrows><?php echo $this->totalRows; ?></totalrows>
		<totalpages><?php echo $this->totalPages; ?></totalpages>
		<currentpage><?php echo $this->currentPage; ?></currentpage>
		<firstrecord><?php echo $this->firstRecord; ?></firstrecord>
		<lastrecord><?php echo $this->lastRecord; ?></lastrecord>
		<error><?php echo ($this->error==0?"no":"yes"); ?></error>
		<errortext><?php echo xmlEncode($this->errorText); ?></errortext>
		<errorno><?php echo $this->error; ?></errorno>
<?php
	}
	
	public function createInserts() {
		$sql="";
		$i=0;
		foreach($this as $row) {
			if($i%20==0) {
				$sql.="\n\nREPLACE INTO $this->table (";
				
				foreach($this->fields as $field) 
					$sql.="`".$field->name."`, ";
				
				$sql=substr($sql,0,strlen($sql)-2);
				$sql.=") VALUES\n";
			}
			
			$sql.=$row->readyForInsert();
			$sql.=", ";
			if($i%20==19) {
				$sql=substr($sql,0,strlen($sql)-2);
				$sql.=";";
			}
			
			$i++;
		}
		if($i%20!=0) {
			$sql=substr($sql,0,strlen($sql)-2);
			$sql.=";";
		}
		
		return $sql;
	}
	
	public function createDataXML($header=false) {
		createTRXMLHeader();
?>
<data>
<?php $this->createXMLRows() ?>
</data>
<?php
	}
	
	public function createJSON(){
		$_jArry=array();
		while($row=$this->result->fetch_array(MYSQLI_ASSOC)){
			$_jArry[]=$row;
		}
		return json_encode($_jArry);
	}
	public function createDataArray(){
		$_jArry=array();
		while($row=$this->result->fetch_array(MYSQLI_ASSOC)){
			$_jArry[]=$row;
		}
		return $_jArry;
	}
	public function createTableXML($header=true,$showfields=false) {
		if($header) 
			createTRXMLHeader();
?>
<table>
<?php if($showfields) { ?>
	<fields>
<?php foreach($this->fields as $field) { ?>
		<field>
			<name><?php echo $field->name ?></name>
			<originalname><?php echo $field->orgname ?></originalname>
			<type><?php echo $field->type ?></type>
			<size><?php echo $field->length ?></size>
			<default><?php echo $field->def ?></default>
		</field>
<?php } ?>
	</fields>
<?php } ?>
	<info>
<?php $this->createXMLInfo() ?>
	</info>
	<rows>
<?php $this->createXMLRows() ?>
	</rows>
</table>
<?php
	}
	
	public function createXMLRows() {
		foreach($this as $row) {
			echo "\t\t<row>\n";
			$row->createXML();
			echo "\t\t</row>\n";
		}
	}
	
	public function dumpXLS() {
		ob_start();
		echo "<tr>";
		foreach($this->fields as $field) { 
?>
			<td class="headerrow"><b><?php echo $field->name ?></b></td>
<?php
		}
		echo "</tr>";
		$this->dumpTableRows();
		$str=ob_get_clean();
		
		xlsWrapRows($str);
	}
	
	public function dumpTableRows() {
		$i=0;
		foreach($this as $row) {
			echo "<tr class='".($i%2?"oddrow":"evenrow")."'>\n";
			$row->createTR();
			echo "</tr>\n";
			$i++;
		}
	}
	
	public function dumpTable() {
?>
		<table cellpadding="3" cellspacing="1" border="0" class="listtable"><tr>
<?php foreach($this->fields as $field) { ?>
				<td class="headerrow"><?php echo $field->name ?></td>
<?php } ?>
			</tr>
<?php 
			$this->dumpTableRows();
?>
		</table>
<?php
	}
}
?>