<?php                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
	class DebugLog {
		const Error=0;
		const Warning=1;
		const Notice=2;
		private function __construct(){
		}

		static function init() {
?>
<script>
	debugwin = window.open("debug.html","debug_log","height=500,width=400");
		
	function reportError(text) {
		setTimeout("debugwin.addError('"+text+"');",200);
		debugwin.focus( );
	}
	
	function reportWarning(text) {
		setTimeout("debugwin.addWarning('"+text+"');",200);
	}
	
	function reportNotice(text) {
		setTimeout("debugwin.addNotice('"+text+"');",200);
	}
</script>
<?php 
		}
			
		static function debugMessage($text,$level=DebugLog::Notice) {
			switch($level) {
			case DebugLog::Error:
				echo "<script>reportError('".str_replace("'","&apos;",str_replace("\r","",str_replace("\n","",$text)))."');</script>";		
				break;
			case DebugLog::Warning:
				echo "<script>reportWarning('".str_replace("'","&apos;",str_replace("\r","",str_replace("\n","",$text)))."');</script>";		
				break;
			case DebugLog::Notice:
				echo "<script>reportNotice('".str_replace("'","&apos;",str_replace("\r","",str_replace("\n","",$text)))."');</script>";		
				break;
			}
		}
	
	}
?>

<?php
	class QueryInspector {
		public $query="";
		public $resultset=NULL;
		public $error=0;
		public $errorText="";
		public static $queryCounter=0;
		
		public function __constructor() {
			$this->queryCounter++;
		}
		
		public function show() {
			if(@$this->resultset===true) {
				$result=true;
				$rowcount=mysqli_affected_rows();
			}
			elseif(@$resultset===false) {
				$result=false;
				$rowcount=0;
			}
			elseif(@$resultset) {
				$result=true;
				$rowcount=$result->num_rows;
			}
			else {
				$result=false;
				$rowcount=0;
			}
			$this->query=str_replace("\r","",$this->query);
			$this->query="AAAAAAAAAABBBBB)".$this->query;
			
			$keywords=array("select","from","where","as","between","in","and","or","order","by","limit","insert","into",
											"values","update","delete","set","case","when","if","then","end","while","for","replace",
											"begin","start","transaction","commit","rollback");
			//$operators=array("\\(","\"","'","\\)","\\+","-","\\/","\\*","!","\\.","\\,");
			
			foreach($keywords as $keyword) 
				$this->query=preg_replace("/([ .,(){}\t\n])($keyword)([ .,(){}\t\n])/ie","'\\1<span class=keyword>'.strtoupper('\\2').'</span>\\3'",$this->query);
				
			/*foreach($operators as $operator)  {
				$this->query=ereg_replace("($operator)","<span class=operator>\\1</span>",$this->query);
				echo $this->query;
			}*/


			$this->query=str_replace("AAAAAAAAAABBBBB)","",$this->query);
			$queries=explode("\n",$this->query);
			if(strstr($this->errorText,"at line")) {
				preg_match("/at line ([0-9]*)/",$this->errorText,$arr);
			}
			$linenum=@$arr[1];
			$i=1;
			foreach($queries as $k=>$query) {
				if($i==$linenum)
					$queries[$k]= "<span class=error>".str_pad($i++,2," ",STR_PAD_LEFT) . ".  " . $query."</span>";
				else
					$queries[$k]= str_pad($i++,2," ",STR_PAD_LEFT) . ".  " . $query;
			}
				
			$this->query=implode("\n",$queries);
			
?>
<script>
	querywin = window.open("query.html","query_win_$this->queryCounter","height=500,width=600");
	querywin.focus();
	setTimeout(function () {
		querywin.document.getElementById("result").innerHTML="<?php echo ($result ? "Success" : "Failed") ?>";
		querywin.document.getElementById("returnedRows").innerHTML="<?php echo $rowcount ?>";
		querywin.document.getElementById("query").innerHTML="<?php echo str_replace(array("\\","\n","\r","\""),array("\\\\","\\n","\\r","&quot;"),$this->query); ?>";
<?php if($this->error>0) { ?>
		querywin.document.getElementById("errorCode").innerHTML="<?php echo $this->error ?>";
		querywin.document.getElementById("errorText").innerHTML="<?php echo str_replace(array("\\","\n","\r","\""),array("\\\\","\\n","\\r","&quot;"),$this->errorText) ?>";
<?php } else { ?>
		querywin.document.getElementById("error").style.display="none";
<?php } ?>
	},500);
</script>
<?php
		}
	}
?>