<?php
function logDBError($db) {
		
		$trace=debug_backtrace();
		for($i=count($trace)-1;$i>=0;$i--) {
			if(@$trace[$i]["class"]=="Database") {
				$id=mt_rand(10000,999999);
				$n=time();
				
				if(os=="linux") {
					$dir="/var/log/".system_name."/queries/".date("Y",$n)."/".date("m",$n);
					`mkdir -p $dir`;
					$fn="$dir/qry".date("dHis",$n)."$id.sql";
					$file=fopen("/var/log/".system_name."/database.".date("Ymd",$n).".log","a");
				} elseif(os=="win32") {
					$dir="c:\\log\\".system_name."\\queries\\".date("Y",$n)."\\".date("m",$n);
					`mkdir $dir`;
					$fn="$dir\\qry".date("dHis",$n)."$id.sql";
					$file=fopen("c:\\log\\".system_name."\\database.".date("Ymd",$n).".log","a");
				}
				
				fwrite($file, date("YmdHis",$n).":".($trace[$i]["function"]).":");
				fwrite($file,$trace[$i]["file"].":".$trace[$i]["line"].":$id:".$db->getErrorNo().":".$db->getErrorText());
				fwrite($file,"\n");
				fclose($file);
				if(@$fn){
					@file_put_contents($fn,$db->lastQuery);
				}
				
				return;
			}
		}
	}
	
 	function parseCondition($where) {
		if(is_array($where)) {
			$ws=$where;
			$where="";
			$op="";
			$opn="";
			$db=Database::database();
			foreach($ws as $k=>$w) {
				if($k{0}=="!" && $w!=$op) {
					if($where)
						$where=" ( $where ) ";
						
					$opn=$w;
				} else {
					if(is_array($w)) {
						$subw=parseCondition($w);
						if($where)
							$where=" ( $where )\n $op ( $subw )";
						else
							$where="( $subw )";
					} 
					elseif(is_numeric($k)) {
						$where.=" $op ($w)";
					}
					elseif(is_object($w)) {
						if(method_exists($w,'get')) 
							$where.=" $op $k='".$w->get()."' ";
						else
							$where.=" $op $k='".$w->id."' ";
					} 
					elseif($w===NULL) {
						$where.=" $op $k IS NULL ";
					}
					else {
						$where.=" $op $k='".$db->escape_string($w)."' ";
					}
						
						
					if($op=="")
						$op="AND";
					if($opn!="") {
						$op=$opn;
						$opn="";
					}
				}
			}
			if(!$where)
				$where="1";
				
			return $where;
		}
		elseif($where=="")
			return "1";
		else
			return $where;
	}
		
	class Database {
		public static $database=NULL;
		public static $settingsDatabase=NULL;
		public static $userDatabase=NULL;
		public static $remoteDatabase=NULL;
		private $db=NULL;
		var $lastQuery="";
		
		const err_columnmismatch=-1;
		
		function __construct($host=NULL,$user=NULL,$password=NULL,$dbname=NULL) {
			if($host==NULL) {
				
				if(system_debug)
					DebugLog::debugMessage("Connecting to default mysql server...");
				
				//include getLibPath()."/defaults.php";
					
				$this->db=@new mysqli(database_host,database_user,database_password,database_dbname);
				if(system_debug) {
				if(mysqli_connect_errno())
					DebugLog::debugMessage("Connection failed: ".mysqli_connect_errno(),DebugLog::Error);
				else
					DebugLog::debugMessage("Connection succeeded.");
				}

			} 
			else {
				if(system_debug)
					DebugLog::debugMessage("Connecting to mysql server @$host (user: $user), database: $dbname...");
				
				$this->db=new mysqli($host,$user,$password);
			}
			
			$this->db->query("set character_set_connection=utf8");
			$this->db->query("set character_set_client=utf8");
			$this->db->query("set character_set_results=utf8");
			$this->db->query("set collation_connection=utf8_turkish_ci");
			
			$this->db->select_db($dbname);
		}
		
		function __destruct() {
			@$this->db->close();
		}
		
		private function _query($q) {
			return $this->db->query($q);
		}
		
		function getError() {
			return $this->db->error;
		}
		
		function getErrorText() {
			return $this->db->error;
		}
		
		function getErrorNo() {
			return $this->db->errno;
		}
		
		function insertId() {
			return $this->db->insert_id;
		}
		
		
		
		
		function query($fields,$from,$where="1",$order="",$page=NULL,$limit=NULL,$group=NULL,$inspect=NULL) {
			if($limit) {
				$count=$this->getValue("COUNT(*)",$from,$where);
			} else
				$count=-1;
				
			$where=parseCondition($where);
			
			if(is_array($fields)) {
				$f="";
				foreach($fields as $k=>$field) {
					if(is_numeric($k))
						$f.=$field.",\n";
					else
						$f.="$field as `$k`,\n";
				}
				
				if($f!="")
					$f=substr($f,0,strlen($f)-2);
					
				$fields=$f;
			}
			
			$q=<<<QUERY
SELECT
  $fields
FROM
  $from
WHERE
  $where
	
QUERY;
			if($group!="")
				$q.="GROUP BY $group\n";
			if($order!="")
				$q.="ORDER BY $order\n";
			
			if($limit) {
				if($page) {
					$numpg=ceil($count/$limit);
					if(($page)>$numpg)
						$page=$numpg;
						
					if($page<1)
						$page=1;
					$start=($page-1)*$limit;
					$q.="LIMIT $start,$limit\n";
				} else {
					$q.="LIMIT $limit\n";
				}
			}
			
			$ret=$this->db->query($q);
			if($ret!==false) {
				if($count==-1)
					$count=$ret->num_rows;
			}

			$this->lastQuery=$q;
			$query=new QueryResult($ret,$this->db->errno,$this->db->error,$count,$limit,$page);
			$query->table=$from;
			$query->db=$this;
 
			if(($ret===false && $inspect!==false) || $inspect) {
				$inspector=new QueryInspector();
				$inspector->query=$q;
				$inspector->error=$this->db->errno;
				$inspector->errorText=$this->db->error;
				$inspector->show();
			}
			
			if($ret===false) {
				logDBError($this);
			}

			return $query;
		}
		
		function execute($query) {
			return $this->db->query($query);
		}
		
		function getValue($field,$from,$where=1,$order="",$inspect=NULL) {
			if($order=="")
				$ord="";
			else
				$ord=" ORDER BY $order ";
				
			$where=parseCondition($where);
				
			$q="SELECT $field FROM $from WHERE $where $ord LIMIT 1";
			$this->lastQuery=$q;
			$ret=$this->db->query($q);
			
			if(($ret===false && $inspect!==false) || $inspect) {
				$inspector=new QueryInspector();
				$inspector->query=$q;
				$inspector->error=$this->db->errno;
				$inspector->errorText=$this->db->error;
				$inspector->show();
			}

			if(!$ret || $ret->num_rows==0)
				return NULL;
				
			$ret=$ret->fetch_row();
	
			if($ret===false) {
				logDBError($this);
			}

			return $ret[0];
		}
		
		function getValues($fields,$from,$where=1,$order="") {
			$ret=$this->query($fields,$from,$where,$order,1,1);
			$ret->table=$from;
			if($ret->error)
				return NULL;
				
			$ret=$ret->next();
			return $ret;
		}
		
		function getValuesIndex($fields,$from,$where=1,$order="") {
			$ret=$this->query($fields,$from,$where,$order,1,1);
			$ret->table=$from;
			if($ret->error)
				return NULL;
				
			$ret=$ret->next();
			$arr=array();
			foreach($ret as $f)
				$arr[]=$f;
				
			return $arr;
		}
		
		function escape_string($text) {
			if(is_object($text)) {
				$trace=debug_backtrace();
				$i=count($trace)-1;
//				for(;$i>=0;$i--) {
						echo "<span class='error'>You cannot use objects in WHERE clause.. used for ".
						$trace[$i]["function"]. " at " . $trace[$i]["file"] . ":" .  $trace[$i]["line"] .
						"</span><br>";
	//			}
				//var_dump($trace);
	
				return "";
			}
			return $this->db->escape_string($text);
		}
		
		static function database() {
			if(Database::$database===NULL) {
				Database::$database=new Database();
				return Database::$database;
			}
				
			return Database::$database;
		}
		
		function startTransaction() {
			$this->db->query("START TRANSACTION");
		}
		
		function commit() {
			$this->db->query("COMMIT");
		}
		
		function rollback() {
			$this->db->query("ROLLBACK");
		}
		
		function deleteAll($table,$where) {
			return $this->delete($table,$where,-1);
		}
		
		function delete($table,$where,$limit=1) {
			if($limit>0)
				$limit="LIMIT $limit";
			else
				$limit="";
				
			$where=parseCondition($where);

			$q=<<<QUERY
DELETE
FROM $table
WHERE
	$where
$limit
QUERY;
			
			$this->lastQuery=$q;
			
			$ret=$this->db->query($q);
			
			if($ret===false) {
				logDBError($this);
			}
						
			return $ret;
		}
		
		function addToAutoComplete($type, $items) {
			if(is_array($items)) {
				$arr=array();
				foreach($items as $item) {
					if(strlen($item)<30)
						$arr[]=array($type,trim($item," "));
				}
					
				$this->massInsert( "actb", array("type","value"), $arr );
			} else {
				if(strlen($items)<30)
					$this->massInsert( "actb", array("type","value"), array(array($type,$items)) );
			}
		}
		
		function massInsert($table,array $columns,array $valueslist) {
			$q=<<<QUERY
INSERT
INTO `$table` (
QUERY;
			foreach($columns as $column)
				$q.="  `$column`,\n";
				
			$q=substr($q,0,strlen($q)-2).")\n VALUES ";
			
			foreach($valueslist as $values) {
				$q.="(";
				foreach($values as $value)
					$q.="'". $this->db->escape_string($value) ."', ";
					
				$q=substr($q,0,strlen($q)-2)."),\n";
			}
			
			$q=substr($q,0,strlen($q)-2)."\n";
			$this->lastQuery=$q;
			$ret=$this->db->query($q);
			return $ret;
		}
		
		function insert($table,array $columns,array $values=NULL,$escape=true,$ignore=false,$inspect=NULL) {
			if($values==NULL) {
				$values=$columns;
				$columns=array_keys($values);
			}
			if(count($columns)!=count($values)) {
				//$this->err=1058;
				return Database::err_columnmismatch;
			}
			
			if($ignore)
				$ignore=" IGNORE ";
			else
				$ignore="";
			
			$q=<<<QUERY
INSERT$ignore
INTO `$table` (
QUERY;
			
			foreach($columns as $column)
				$q.="  `$column`,\n";
				
			$q=substr($q,0,strlen($q)-2).")\nVALUES(";
			
			foreach($values as $value) {
				if($escape) {
					if($value===NULL)
						$q.="NULL,\n";
					elseif($value===true)
						$q.="1,\n";
					elseif($value===false)
						$q.="0,\n";
					elseif(is_array($value)) {
						$trace=debug_backtrace();
						$i=count($trace)-2;
						echo "<span class='error'>You cannot use objects in WHERE clause.. used for ".
						$trace[$i]["function"]. " at " . $trace[$i]["file"] . ":" .  $trace[$i]["line"] .
						"</span><br>";
					}
					elseif(is_object($value)) {
						$trace=debug_backtrace();
						$i=count($trace)-2;
						echo "<span class='error'>You cannot use objects in WHERE clause.. used for ".
						$trace[$i]["function"]. " at " . $trace[$i]["file"] . ":" .  $trace[$i]["line"] .
						"</span><br>";
					}
					else
						$q.="'". $this->db->escape_string($value) ."',\n";
				}
				else	
					$q.=$value.",\n";
			}
				
			$q=substr($q,0,strlen($q)-2).");\n";
			$this->lastQuery=$q;
			$ret=$this->db->query($q);
			
			if((($ret===false && $inspect!==false) || $inspect) && system_debug) {
				$inspector=new QueryInspector();
				$inspector->query=$q;
				$inspector->error=$this->db->errno;
				$inspector->errorText=$this->db->error;
				$inspector->show();
			}

			if(!$ret) {			
				logDBError($this);
				return false;
			}
			else
				return $this->db->insert_id;
		}
		
		function update($table,$values,$where,$fixValues=true,$limit=NULL,$order="") {
			$q=<<<QUERY
UPDATE `$table` 
SET
QUERY;
			
			foreach($values as $column=>$value) {
				$q.="  `$column`=";
				if($fixValues) {
					if($value===NULL)
						$q.="NULL,\n";
					else
						$q.="'". $this->db->escape_string($value) ."',\n";
				}
				else
					$q.="$value,\n";
				
			}
				
			$where=parseCondition($where);

			$q=substr($q,0,strlen($q)-2)."\n";
			$q.="WHERE \n\t$where";
			
			if($order)
				$q.="\nORDER BY $order";
			if($limit)
				$q.="\nLIMIT $limit";

			$this->lastQuery=$q;
			$ret=$this->db->query($q);
						
			if($ret===false) {
				logDBError($this);
			}

			return $ret;
		}
		
		function call($procedure,array $params) {
			$q="call `$procedure`(\n";
			
			foreach($params as $param) {
				$q.="  '". mysql_real_escape_string($param)."',\n";
			}
			
			$q=substr($q,0,strlen($q)-2).");\n";
			$this->lastQuery=$q;
			$ret=$db->query($q);
						
			if($ret===false) {
				logDBError($this);
			}

			return $ret;
		}
		
		static function settingsDatabase() {
			if(Database::$settingsDatabase===NULL) {
				Database::$settingsDatabase=new Database(settings_host,settings_user,settings_password,settings_dbname);
				return Database::$settingsDatabase;
			}
				
			return Database::$settingsDatabase;
		}
		
		static function userDatabase() {
			if(Database::$userDatabase===NULL) {
				Database::$userDatabase=new Database(userdb_host,userdb_user,userdb_password,userdb_dbname);
				return Database::$userDatabase;
			}
				
			return Database::$userDatabase;
		}
		static function remoteDatabase() {
			if(Database::$remoteDatabase===NULL) {
				Database::$remoteDatabase=new Database(remotedb_host,remotedb_user,remotedb_password,remotedb_dbname);
				return Database::$remoteDatabase;
			}
		
			return Database::$remoteDatabase;
		}
		function useDatabase($dbname) {
			if(Database::$database===$this)
				return false;
			$this->db->select_db($dbname);
		}
		
		function close() {
			if(Database::$database===$this)
				return false;
			$this->db->close();
		}
		
		function __toString() {
			return $this->db->stat();
		}
	};
?>