<?php

if(!function_exists("unrealpath")) {
	
	define("version", "0");
	define("major", "2");
	define("revision", "0");
		//Credit: Santosh Patnaik (modified: Zach Bernal)
    function unrealpath($start_dir, $final_dir, $dirsep = DIRECTORY_SEPARATOR){
        //Directory separator consistency
        $start_dir = str_replace('/',$dirsep,$start_dir);
        $final_dir = str_replace('/',$dirsep,$final_dir);
        $start_dir = str_replace('\\',$dirsep,$start_dir);
        $final_dir = str_replace('\\',$dirsep,$final_dir);

        //'Splode!
        $firstPathParts = explode($dirsep, $start_dir);
        $secondPathParts = explode($dirsep, $final_dir);
       
        //Get the number of parts that are the same.
        $sameCounter = 0;
        for($i = 0; $i < min( count($firstPathParts), count($secondPathParts) ); $i++) {
            if( strtolower($firstPathParts[$i]) !== strtolower($secondPathParts[$i]) ) {
                break;
            }
            $sameCounter++;
        }
        //If they do not share any common directories/roots, just return 2nd path.
        if( $sameCounter == 0 ) {
            return $final_dir;
        }
        //init newpath.
        $newPath = '';
        //Go up the directory structure count(firstpathparts)-sameCounter times (so, go up number of non-matching parts in the first path.)
        for($i = $sameCounter; $i < count($firstPathParts); $i++) {
            if( $i > $sameCounter ) {
                $newPath .= $dirsep;
            }
            $newPath .= "..";
        }
        //if we did not have to go up at all, we're still in start_dir.
        if( strlen($newPath) == 0 ) {
            $newPath = ".";
        }
        //now we go down as much as needed to get to final_dir.
        for($i = $sameCounter; $i < count($secondPathParts); $i++) {
            $newPath .= $dirsep;
            $newPath .= $secondPathParts[$i];
        }
        //
        return $newPath;
    }
	}
if(!function_exists("__autoload")) {
	$ctx_section="";
	$ctx_subsection="";

	function getLibPath() {
		return unrealpath(getcwd(),dirname(__FILE__));
	}
	
	function getPath($path) {
		return unrealpath(getcwd(),realpath(dirname(__FILE__)."/..")."/$path");
	}
	
	function includeJS($file) {
?>
<script src="<?php echo getPath("js"); ?>/<?php echo $file ?>" language="javascript" type="text/javascript"></script>
<?php
	}
	function xmlEncode($text) {
		$from=array("&","<",">","\"","'", "`", "\\\\","�");
		$to=array("&amp;","&lt;","&gt;","&quot;","&apos;", "&grave;",  "&bsol;","");
		
		return str_replace($from,$to,$text);
	}
	function fixString($string) {
		 return xmlEncode($string);
	}
	function fixArray($array) {
		foreach($array as $k=>$post) {
			if(is_array($array[$k]))
				fixArray($array[$k]);
			else
				$array[$k]=fixString($post);
		}
		return  $array;
	}
	function fixREQUESTString() {
		return fixArray($_REQUEST);
	}
	function fixPOSTString() {
		return fixArray($_POST);
	}
		include_once getLibPath()."/defaults.php";
	
	
	/*include_once getLibPath()."/stdlib.php";
	include_once getLibPath()."/logger.php";
	include_once getLibPath()."/context.php";
	include_once getLibPath()."/authorization.php"; */
	//include_once getPath("data")."/updateinfo.php";
	class Value {
		public $object;
		public $value;
		
		function __construct($object, $value) {
			$this->object=$object;
			$this->value =$value;
		}
		
		function get() {
			$val=$this->value;
			return $this->object->$val;
		}
	}
	
	function sendMailViaGmail($_toMail,$_kAdi,$_kSifre){
		require 'mailler/PHPMailerAutoload.php';
		$mail = new PHPMailer;
		$mail->isSMTP();
		$mail->SMTPDebug = 0;
		$mail->Debugoutput = 'html';
		$mail->Host = 'localhost';
		$mail->Port = 587;
		$mail->SMTPSecure = 'tls';
		$mail->SMTPAuth = true;
		$mail->Username = "borcsorgula@dikmenbelediyesi.com";
		$mail->Password = "Borcsorgula123!!";
		$mail->setFrom('info@dikmenbelediyesi.com', 'info@dikmenbelediyesi.com');
		$mail->addReplyTo('info@dikmenbelediyesi.com', 'info@dikmenbelediyesi.com');
		$mail->addAddress($_toMail,$_toMail);
		$mail->Subject = 'Dikmen Belediyesi Kullanıcı Hesabı.';
		$icerik="DIKMEN BELEDIYESI KULLANICI ADINIZ: ".$_kAdi." , SIFRENIZ :". $_kSifre." . www.dikmenbelediyesi.com ";
		$mail->msgHTML($icerik);
		if (!$mail->send()) {
			return true;
		} else {
			return false;
		}
	}
    
	function __autoload($classname) {
		switch($classname) {
			case "QueryResult":
				include_once getLibPath()."/queryresult.php";
				break;
        case "SmartObject":
		case "DataFunction":
			include_once getLibPath()."/smartobject.php";
			break;
		case "DebugLog":
		case "QueryInspector":
			include_once getLibPath()."/debuglogger.php";
			break; 
		case "Database":
			include_once getLibPath()."/database.php";
			break;
		
		case "User":
				include_once getLibPath()."/users.php";
			break;
		case "PostaGuvercini":
				include_once getLibPath()."/postaguvercini.php";
			break;
		 case "Query":
            include_once getLibPath()."/query.php";
            break;
			default:
			if(substr($classname,0,7)=="Virtual") {
				include_once getPath("database")."/".strtolower(substr($classname,7)).".php";
			}
				
				
		}
	}
}
include_once getLibPath()."/settings.php";

?>
